	function PLOT_h_s_S(h, h_scale, s_of_t, t_axis, tmax, ymin, ymax)
	
	%	Plots the impulse and step responses for an analog filter in a single figure
	
	% Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% Author: 			Lars Wanhammar 2007-09-13
	% Modified by: 	 	 
	% Copyright:		by authors - not released for commercial use
	% Version:			1
	% Known bugs: 
	% Report bugs to:	Wanhammar@gmail.com
	
	%========================================================	
	% Standard settings
	fs = 16; % Font size
	lw = 2; % Linewidth
	fn = 'times'; % Font
	%========================================================
	figure
	subplot('position', [0.08 0.4 0.86 0.5]);
	axis([0, tmax, ymin, ymax]);
	plot(t_axis, h*h_scale,'linewidth',lw); 
	hold on;
	plot(t_axis, s_of_t,'linewidth',lw); 
	grid on	
	xlabel('{\itt}   [s]','FontName',fn,'FontSize',fs);
 	set(gca,'FontName', fn,'FontSize', fs);
	
	% write text in the figure.  MAY be modified
	% Example 7.2
	%	text(7*10^-4, 0.9,'{\its}({\itt})','FontName',fn,'FontSize',fs);
	% 	text(7*10^-4, 0.3,'{\ith}({\itt}){*5}{*10^-^5}','FontName',fn,'FontSize',fs);
	% Example 7.3
	% text(5*10^-4, 0.9,'{\its}({\itt})','FontName',fn,'FontSize',fs);
	% text(5*10^-4, 0.3,'{\ith}({\itt}){*5}{*10^-^5}','FontName',fn,'FontSize',fs);
	% Exaample 7.4 and 7.5 
	text(2.5*10^-4, 0.9,'{\its}({\itt})','FontName',fn,'FontSize',fs);
 	text(4*10^-4, 0.3,'{\ith}({\itt}){*5}{*10^-^5}','FontName',fn,'FontSize',fs);
	
